/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xpciapi.h
 * -----------------------------------------------------------------*/

#ifndef XPCI_API_H_INCLUDED
#define XPCI_API_H_INCLUDED

#include <xtypedef.h>

#include <xboard.h>
#include <xdecode.h>
#include <xdynamic.h>
#include <xhost.h>
#include <xladata.h>
#include <xlatrig.h>
#include <xanalyze.h>
#include <xexer.h>
#include <xri.h>
#include <xrt.h>
#include <xci.h>
#include <xct.h>
#include <xobserve.h>
#include <xsequenc.h>
#include <xperfseq.h>
#include <xsession.h>
#include <xmailbox.h>
#include <xpattern.h>

#include <xerrcapi.h>
#include <xiocommo.h>
#include <xversion.h>

#include <xsetting.h>
#include <xutil.h>

#ifdef CUSTOM_OEM1
#include <oem.h>
#endif

#ifndef CLI
#define CLI
#endif

#ifdef __cplusplus
extern "C" {
#endif
  
/* the following typedef is for compatibility with the MS Compiler */
typedef char * MS_STR;

/* -----------------------------------------------------------------
 * Power Up Loader Functions 
 * ----------------------------------------------------------------- */

CLI bx_errtype EXPORT BestXPUProg(                 /* @puprog */            
  bx_handletype handle
);

bx_errtype EXPORT BestXPULoaderCodeGet( 
  bx_handletype handle,
  bx_int8ptr LoaderCode,
  bx_int32ptr LoaderLengthPtr
);

bx_errtype EXPORT BestXPURead(                     /* @puread */           
  bx_handletype handle
);

CLI bx_errtype EXPORT BestXPURestore(              /* @purestore */           
  bx_handletype handle
);

CLI bx_errtype EXPORT BestXLoaderDecode(           /* @loaderdecode     */
  bx_handletype handle,
  char *file,                                      /* $"c:\\bx_pucode.txt" */
  bx_int32 addr                                    /* $0x100000          */
);

bx_errtype EXPORT BestXEraseFlash (bx_handletype handle,
                                   bx_int32 numsectors,
                                   const bx_int32ptr sectors);

bx_errtype EXPORT BestXWriteFlash(bx_handletype handle,
                                  bx_int32 sector,
                                  bx_int8 *data,
                                  bx_int32 datalen);

/* -----------------------------------------------------------------
 * BestX PME Register Functions 
 * ----------------------------------------------------------------- */
    
CLI bx_errtype EXPORT BestXPMEWrite(       /* @pmewrite */
  bx_handletype handle,
  bx_int32      val                    
);

CLI bx_errtype EXPORT BestXPMERead(        /* @pmeread */
  bx_handletype handle,
  bx_int32      *val                       /* #RETURN "0x%08lx" */
);

/* -----------------------------------------------------------------
 * Interrupt Generation Functions 
 * ----------------------------------------------------------------- */

CLI bx_errtype EXPORT BestXInterruptGenerate(     /* @interruptgenerate */
  bx_handletype handle,
  bx_int32      intr
);


CLI bx_errtype EXPORT BestXInterruptClear(     /* @interruptclear */
  bx_handletype handle,
  bx_int32 intr 
);

CLI bx_errtype EXPORT BestXInterruptStatus(     /* @interruptstatus */
  bx_handletype handle,
  bx_int32 * intr                               /* #RETURN "0x%02lx" */
);

/* -----------------------------------------------------------------
 * Tiny LED Functions 
 * ----------------------------------------------------------------- */

CLI bx_errtype EXPORT BestXLedSet(         
  bx_handletype handle,
  bx_int32      val                       
);

/* -----------------------------------------------------------------
 * Hex display Functions 
 * ----------------------------------------------------------------- */

CLI bx_errtype EXPORT BestXDisplayWrite(           /* @displaywrite */
  bx_handletype handle,
  bx_int32      val                            
);

CLI bx_errtype EXPORT BestXDisplayStringWrite(     /* @displaystringwrite */
  bx_handletype    handle,
  bx_charptrtype   string    
);

CLI bx_errtype EXPORT BestXDisplayMessageWrite(     /* @displaymessagewrite */
  bx_handletype    handle,
  bx_int32 speed,                                   /* $250 */
  bx_charptrtype   msg                              /* $"Hubabubah" */
);


/* -----------------------------------------------------------------
 * Miscellaneous Functions 
 * ----------------------------------------------------------------- */
 
CLI bx_errtype  EXPORT BestXSMReset(              /* @smreset */
  bx_handletype handle 
);


CLI bx_errtype  EXPORT BestXBoardReset(        /*  @boardreset  */    
  bx_handletype handle
);

CLI bx_errtype  EXPORT BestXBoardSoftReset(    /*  @boardsoftreset  */    
  bx_handletype handle
);


CLI bx_errtype EXPORT BestXBoardRestart (         /* @boardrestart */
  bx_handletype handle
);


CLI bx_errtype EXPORT BestXCapiPropSet(           /* @capiprpset */
  bx_handletype    handle,
  bx_capiproptype  prop,                      /* @prop */
  bx_int32         value                          /* @val */
);


CLI bx_errtype EXPORT BestXCapiPropGet(           /* @capiprpget */
  bx_handletype    handle,
  bx_capiproptype  prop,                       /* @prop */
  bx_int32         *value                      /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT BestXVersionRead(           /* @versionread */
  bx_handletype      handle,
  bx_versiontype prop,                       /* @prop */
  bx_charptrtype     *string      /* #RETURN "\"%s\"" */
);

bx_errtype EXPORT BestXFlashProg(           
  bx_handletype handle,
  bx_int32 dest,
  bx_int8ptr code,
  bx_int32 codelength
);

bx_errtype BestXSyncRegWrite(
  bx_handletype handle,
  bx_int32 stat_addr,  /* Status register address  */
  bx_int32 stat_size,  /* Status register size     */
  bx_int32 stat_mask,  /* Status register mask     */
  bx_int32 stat_value, /* Status ready value       */
  bx_int32 ctrl_addr,  /* Control register address */
  bx_int32 ctrl_size,  /* Control register size    */
  bx_int32 ctrl_mask,  /* Control register mask    */
  bx_int32 ctrl_value, /* Control register value   */
  bx_int32 sync_addr,  /* Sync register address    */
  bx_int32 force_addr, /* Force register address   */
  bx_int32 force_size, /* Force register size      */
  bx_int32 DoForce     /* Force the write after trying a synced write */
);

bx_int32 EXPORT BestXVersionCompare(
  const bx_vertype *ver1,
  const bx_vertype *ver2
); 

#ifdef __cplusplus
}
#endif


#endif






